 aR  w / m^9      h	 oP      nSystem-wide$NOLIST

        NAME  Mini2Dos

;  This module contains routines that make MsDos calls accessible to Pascal.

CGROUP GROUP CODE

PUBLIC  MsOpen, MsClose, MsRead, MsWrite, MsSeek, MsFileSize
PUBLIC  MsCreate, MsDelete, MsRename
PUBLIC  MsAllocate, MsFree, MsAvailableMemory
PUBLIC  MsGetArgument, MsProgramName, MsExit

EXTRN   DosAlloc: NEAR, DosFree: NEAR

; EQUATES

eOK		         EQU 0
fnCallInt         EQU 21H


CODE SEGMENT PUBLIC 'CODE'
  ASSUME CS:CGROUP
$EJECT

;  MsOpen: PROCEDURE (pPathName, access, pError) WORD CLEAN;
;    DCL access     BYTE;
;    DCL pPathname  PTR;
;    DCL pError     PTR;

pError     EQU DWORD PTR [BP+6]	; parm 3
access     EQU BYTE  PTR [BP+10]	; parm 2
pPathname  EQU DWORD PTR [BP+12]	; parm 1

MsOpen PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    LDS  DX, pPathname	; DS:DX => pathname
    MOV  AL, access
    MOV  AH, 3DH	; Open
    INT	21H	; CALL MsDos

    LDS  DI, pError
    MOV  WORD PTR DS:[DI], eOK
    JNC  MsOpenExit

    MOV  DS:[DI], AX	; DS:DI => Error

MsOpenExit:
    POP  BP	; conn returned in AX
    POP  DS
    RET  10
MsOpen ENDP

PURGE pError, access, pPathname
$EJECT

;  MsClose: PROCEDURE (conn, pError) CLEAN;
;    DCL conn       WORD;
;    DCL pError     PTR;

pError EQU DWORD PTR [BP+6]	; parm 2
conn   EQU WORD  PTR [BP+10]	; parm 1

MsClose PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    MOV  BX, conn
    MOV  AH, 3EH	; Close
    INT	21H	; Call MsDos

    LDS  DI, pError
    MOV  WORD PTR DS:[DI], eOK
    JNC  MsCloseExit

    MOV  DS:[DI], AX	; DS:DI => Error

MsCloseExit:
    POP  BP
    POP  DS
    RET  6
MsClose ENDP

PURGE pError, conn
$EJECT

;  MsRead: PROCEDURE (conn, pBuffer, count, pError) WORD CLEAN;
;    DCL conn       WORD;
;    DCL count      WORD;
;    DCL pBuffer    PTR;
;    DCL pError     PTR;

pError    EQU DWORD PTR [BP+6]	; parm 4
count     EQU WORD  PTR [BP+10]	; parm 3
pBuffer   EQU DWORD PTR [BP+12]	; parm 2
conn      EQU WORD  PTR [BP+16]	; parm 1

MsRead PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    MOV  BX, conn
    MOV  CX, count
    LDS  DX, pBuffer
    MOV  AH, 3FH	; Read
    INT	21H	; Call MsDos

    LDS  DI, pError
    MOV  WORD PTR DS:[DI], eOK
    JNC  MsReadExit

    MOV  DS:[DI], AX	; DS:DI => Error

MsReadExit:
    POP  BP	; Number of bytes read returned in AX
    POP  DS
    RET  12
MsRead ENDP

PURGE pError, count, pBuffer, conn
$EJECT

;  MsWrite: PROCEDURE (conn, pBuffer, count, pError) WORD CLEAN;
;    DCL conn       WORD;
;    DCL count      WORD;
;    DCL pBuffer    PTR;
;    DCL pError     PTR;

pError    EQU DWORD PTR [BP+6]	; parm 4
count     EQU WORD  PTR [BP+10]	; parm 3
pBuffer   EQU DWORD PTR [BP+12]	; parm 2
conn      EQU WORD  PTR [BP+16]	; parm 1

MsWrite PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    MOV  BX, conn
    MOV  CX, count
    LDS  DX, pBuffer
    MOV  AH, 40H	; Write
    INT	21H	; Call MsDos

    LDS  DI, pError
    MOV  WORD PTR DS:[DI], eOK
    JNC  MsWriteExit

    MOV  DS:[DI], AX	; DS:DI => Error

MsWriteExit:
    POP  BP	; Number of bytes written returned in AX
    POP  DS
    RET  12
MsWrite ENDP

PURGE pError, count, pBuffer, conn
$EJECT

;  MsSeek: PROCEDURE (conn, mode, count, pError) DWORD CLEAN;
;    DCL mode       BYTE;
;    DCL conn       WORD;
;    DCL count      DWORD;
;    DCL pError     PTR;

seekBegPlus EQU 0
seekCurPlus EQU 1
seekEndPlus EQU 2

pError      EQU DWORD PTR [BP+6]	; parm 4
count       EQU DWORD PTR [BP+10]	; parm 3
mode        EQU BYTE  PTR [BP+14]	; parm 2
conn        EQU WORD  PTR [BP+16]	; parm 1

MsSeek PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    LDS  DX, count
    MOV  CX, DS	; CX:DX => count
    MOV  BX, conn	; BX = conn
    MOV  AL, mode	; AL = mode
    MOV  AH, 42H	; Seek
    INT	21H	; Call MsDos

    LDS  DI, pError
    MOV  WORD PTR DS:[DI], eOK
    JNC  MsSeekExit

    MOV  DS:[DI], AX	; DS:DI => Error

MsSeekExit:
    POP  BP	; DX:AX => new file position
    POP  DS
    RET  12
MsSeek ENDP

PURGE pError, count, mode, conn
$EJECT

;  MsFileSize: PROCEDURE (conn, pError) DWORD CLEAN;
;    DCL conn       WORD;
;    DCL pError     PTR;

pError      EQU DWORD PTR [BP+6]	; parm 2
conn        EQU WORD  PTR [BP+10]	; parm 1

MsFileSize PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    LDS  DI, pError
    MOV  WORD PTR DS:[DI], eOK	; Preset error code to okay

    MOV  BX, conn	; BX = conn
	XOR	CX, CX
    MOV  DX, CX	; CX:DX => count (mov forward zero)
	MOV	AX, 4200H + seekCurPlus	; Seek to cur position plus 0
    INT	21H	; Call MsDos
    JC	MsFileSizeError

	MOV	DI, DX
	MOV	SI, AX	; Save current file position in DI:SI

	XOR	CX, CX
    MOV  DX, CX	; CX:DX => count (mov forward zero)
	MOV	AX, 4200H + seekEndPlus	; Seek to end plus 0
    INT	21H	; Call MsDos
    JC	MsFileSizeError

	MOV	BX, DX	; Save DX in BX
	MOV	CX, DI
	MOV	DX, SI	; CX:DX => original file position
	MOV	DI, BX
	MOV	SI, AX	; Save end of file position in DI:SI
    MOV  BX, conn	; BX = conn
	MOV	AX, 4200H + seekBegPlus	; Seek back to original file position
    INT	21H	; Call MsDos
    JC	MsFileSizeError

	MOV	DX, DI
	MOV	AX, SI	; Return file size in DX:AX
	JMP	SHORT MsFileSizeExit

MsFileSizeError:
    LDS  DI, pError
    MOV  DS:[DI], AX	; DS:DI => Error

MsFileSizeExit:
    POP  BP	; DX:AX => new file position
    POP  DS
    RET  6
MsFileSize ENDP

PURGE pError, conn
$EJECT

;  MsCreate: PROCEDURE (pPathName, attribute, pError) WORD CLEAN;
;    DCL attribute  WORD;
;    DCL pPathname  PTR;
;    DCL pError     PTR;

pError     EQU DWORD PTR [BP+6]	; parm 3
attribute  EQU WORD  PTR [BP+10]	; parm 2
pPathname  EQU DWORD PTR [BP+12]	; parm 1

MsCreate PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    LDS  DX, pPathname	; DS:DX => pathname

    MOV  CX, attribute
    MOV  AH, 3CH	; Create
    INT	21H	; CALL MsDos

    LDS  DI, pError
    MOV  WORD PTR DS:[DI], eOK
    JNC  MsCreateExit

    MOV  DS:[DI], AX	; DS:DI => Error

MsCreateExit:
    POP  BP	; Conn returned in AX
    POP  DS
    RET  10
MsCreate ENDP

PURGE pError, attribute, pPathname
$EJECT

;  MsDelete: PROCEDURE (pPathname, pError) CLEAN;
;    DCL pPathname  PTR;
;    DCL pError     PTR;

pError    EQU DWORD PTR [BP+6]	; parm 2
pPathName EQU DWORD PTR [BP+10]	; parm 1

MsDelete PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    LDS  DX, pPathname
    MOV  AH, 41H	; Delete
    INT	21H	; Call MsDos

    LDS  DI, pError
    MOV  WORD PTR DS:[DI], eOK
    JNC  MsDeleteExit

    MOV  DS:[DI], AX	; DS:DI => Error

MsDeleteExit:
    POP  BP
    POP  DS
    RET  8
MsDelete ENDP

PURGE pError, pPathname
$EJECT

;  MsRename: PROCEDURE (pOldName, pNewName, pError) CLEAN;
;    DCL pOldName   PTR;
;    DCL pNewName   PTR;
;    DCL pError     PTR;

pError    EQU DWORD PTR [BP+6]	; parm 3
pNewName  EQU DWORD PTR [BP+10]	; parm 2
pOldName  EQU DWORD PTR [BP+14]	; parm 1

MsRename PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    LDS  DX, pOldName
    LES  DI, pNewName
    MOV  AH, 56H	; Rename
    INT	21H	; Call MsDos

    LDS  DI, pError
    MOV  WORD PTR DS:[DI], eOK
    JNC  MsRenameExit

    MOV  DS:[DI], AX	; DS:DI => Error

MsRenameExit:
    POP  BP
    POP  DS
    RET  12
MsRename ENDP

PURGE pError, pNewName, pOldName
$EJECT

;  MsProgramName: PROCEDURE (pPgmNameLen) PTR CLEAN;
;    DCL pPgmNameLen PTR;
;    DCL pgmNameLen  BASED pPgmNameLen WORD;

envOffset   EQU 2CH

pPgmNameLen EQU DWORD PTR [BP+6]	; parm 1

MsProgramName PROC NEAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP

	MOV	AH, 51H	; Get program prefix segment
	INT	21H	; Call MsDos
	MOV	ES, BX	; Returned in BX

	MOV	BX, envOffset
	MOV	ES, ES:[BX]	; Get environment segment

	CLD
	MOV	CX, 8000H	; Environment will be no longer than 32K
	XOR	DI, DI	; Offset into environment
	MOV	AX, DI	; Search for zero

MsProgNameLoop:
	REPNZ SCASB	; Search for end of this environment entry
	SCASB	; See if followed by terminating zero
	JNE	MsProgNameLoop	; If not, then skip next environment entry

	INC	DI
	INC	DI
	MOV	BX, DI	; ES:BX => Program name (in asciiZ format)

	MOV	CX, 0FFFFH
	REPNZ SCASB	; Look for terminating 0 (to find length)
	NOT	CX
	DEC	CX	; CX has length of program name

	LDS	SI, pPgmNameLen
	MOV	DS:[SI], CX	; Set program name length for caller

	MOV	DX, ES
	MOV	AX, BX	; Return MsDos compiler compatible ptrs also

	POP	BP
	POP	DS
	RET	4
MsProgramName ENDP
$EJECT

;  MsExit: PROCEDURE (exitCode) CLEAN;
;    DCL exitCode  BYTE

exitCode EQU BYTE PTR [BP+4]	; parm 1

MsExit PROC NEAR
    PUSH BP
    MOV  BP, SP

    MOV  AL, exitCode
    MOV  AH, 4CH
    INT  fnCallInt

    POP  BP
    RET  2
MsExit  ENDP

PURGE exitCode
$EJECT

;  MsGetArgument: PROCEDURE (pArgBuffer, pArgLength) BYTE CLEAN;
;    DCL pArgBuffer  PTR
;    DCL pArgLength  PTR

pArgLength EQU DWORD PTR [BP+6]	; parm 2
pArgBuffer EQU DWORD PTR [BP+10]	; parm 1

argIndex DW 81H	; Note: Can only be called once in a TSR pgm

; If first char is a space or tab, skip until not space or tab (or cr)
; Read characters until delimeter character is found (space,tab,comma,cr)
; and store characters into destination buffer up to the delimeter

MsGetArgument PROC NEAR
	PUSH	DS
    PUSH BP
    MOV  BP, SP

	MOV	AH, 51H	; Get program prefix segment
	INT	21H	; Call MsDos
	MOV	DS, BX	; Returned in BX
	MOV	SI, CS:argIndex

	LES	DI, pArgBuffer	; Destination for next argument
	XOR	CX, CX	; Init length of argument to 0
	CLD		; Get/Store next character

NextSkipWhiteSpace:
	LODSB	; Get next character
	CMP	AL, 0DH	; If it is a carriage return
	JE	DoneCR	; then done getting argument

	CMP	AL, 20H	; If it is a space
	JE	NextSkipWhiteSpace	; then skip it

	CMP	AL, 09H	; Or if it is a tab
	JE	NextSkipWhiteSpace	; then skip it

AddInNextChar:
	INC	CX	; Increment argument length
	STOSB	; Store character in argument buffer

	LODSB	; Get next character
	CMP	AL, 0DH	; If it is a carriage return
	JE	DoneCR	; then done getting argument

	CMP	AL, 20H	; If it is a space (or any control char)
	JBE	Done	; then treat it as a delimeter

	CMP	AL, 2CH	; If it is not a comma
	JNE	AddInNextChar	; then add the char to argument buffer

DoneCR:
	DEC	SI	; Back up so all arg after this return cr

Done:
	MOV	CS:argIndex, SI	; Store index to next chars of argument buffer

	LDS	SI, pArgLength	; pointer to length variable
	MOV	DS:[SI], CX	; store length
	CMP	AL, 09H	; If delimeter is not a tab
	JNE	MsGetArgumentRet	; then return the delimeter

	MOV	AL, 20H	; Substitute space for tab delimeter

MsGetArgumentRet:
    POP  BP
	POP	DS
    RET  8
MsGetArgument ENDP

PURGE pArgLength, pArgBuffer
$EJECT

;  MsAllocate: PROCEDURE (numBytes, pNewPtr, pError) CLEAN;
;    DCL numBytes   WORD;
;	 DCL pNewPtr    PTR;
;    DCL pError     PTR;

pError   EQU DWORD PTR [BP+6]	; parm 3
pNewPtr  EQU DWORD PTR [BP+10]	; parm 2
numBytes EQU  WORD PTR [BP+14]	; parm 1

MsAllocate PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    MOV  BX, numBytes
    ADD  BX, 15
    MOV  CL, 4
    SHR  BX, CL
	CALL	DosAlloc	; Interface call to Int21, fnc 48H

    LDS  DI, pError
    MOV  WORD PTR DS:[DI], eOK
    JNC  MsAllocateExit

    MOV  DS:[DI], AX	; DS:DI => Error
	XOR	AX, AX	; Set new pointer to null, if error

MsAllocateExit:
	LDS	SI, pNewPtr
	MOV	WORD PTR DS:[SI], 0	; Offset of pointer is always zero
	MOV	WORD PTR DS:[SI+2], AX	; Segment of pointer returned by MsDos Alloc

    POP  BP
    POP  DS
    RET  10
MsAllocate ENDP

PURGE pError, pNewPtr, numBytes
$EJECT

;  MsFree: PROCEDURE (pPtr, pError) CLEAN;
;    DCL pPtr    PTR;
;    DCL pError  PTR;

pError EQU DWORD PTR [BP+6]	; parm 2
pPtr   EQU DWORD PTR [BP+10]	; parm 1

MsFree PROC NEAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    LES  SI, pPtr
	LES	SI, DWORD PTR ES:[SI]
	MOV	AX, ES	; Check for freeing null ptrs (=0)
	OR	AX, SI	; Clears carry flag
	JZ	MsFreeSetError	; Return okay if freeing null ptr

	CALL	DosFree	; Interface call to Int21, fnc 49H

MsFreeSetError:
    LDS  DI, pError
    MOV  WORD PTR DS:[DI], eOK
    JNC  MsFreeExit

    MOV  DS:[DI], AX	; DS:DI => Error

MsFreeExit:
    POP  BP
    POP  DS
    RET  8
MsFree ENDP

PURGE pError, pPtr
$EJECT

;  MsAvailableMemory: PROCEDURE WORD CLEAN;

MsAvailableMemory PROC NEAR
    MOV  BX, 0FFFFH	; Ask for enough to guarantee failure
	CALL	DosAlloc	; Interface call to Int21, fnc 48H
    MOV  AX, BX
    RET
MsAvailableMemory ENDP


CODE    ENDS

        END
